using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class PlayerMenu : MonoBehaviour
{
    public Text levelText, hitpointText, coinsText, upgradeCostText, xpText;

    private int currentPlayerSelection = 0;
    public Image playerSelectionSprite;
    public Image weaponSprite;
    public RectTransform xpBar;

    //Speletaju izvele
    public void OnArrowClick(bool right)
    {
        if (right)
        {
            currentPlayerSelection++;

            if (currentPlayerSelection == GameManager.instance.playerSprites.Count)
                currentPlayerSelection = 0;

            OnSelectionChanged();
        }
        else
        {
            currentPlayerSelection--;

            if (currentPlayerSelection < 0)
                currentPlayerSelection = GameManager.instance.playerSprites.Count - 1;

            OnSelectionChanged();
        }
    }
    private void OnSelectionChanged()
    {
        playerSelectionSprite.sprite = GameManager.instance.playerSprites[currentPlayerSelection];
        GameManager.instance.player.SwapSprite(currentPlayerSelection);
    }

    //Iekartas uzlabosana
    public void OnUpgradeClick()
    {
        if (GameManager.instance.TryUpgradeWeapon())
            UpdateMenu();
    }

    public void UpdateMenu()
    {
        //Iekarta
        weaponSprite.sprite = GameManager.instance.weaponSprites[GameManager.instance.weapon.weaponLevel];
        if (GameManager.instance.weapon.weaponLevel == GameManager.instance.weaponPrices.Count)
            upgradeCostText.text = "MAX";
        else
            upgradeCostText.text = GameManager.instance.weaponPrices[GameManager.instance.weapon.weaponLevel].ToString();

        levelText.text = GameManager.instance.GetCurrentLevel().ToString();
        hitpointText.text = GameManager.instance.player.hitpoint.ToString();
        coinsText.text = GameManager.instance.coins.ToString();

        //Pieredze
        int currentLevel = GameManager.instance.GetCurrentLevel();
        if (currentLevel == GameManager.instance.xpTable.Count)
        {
            xpText.text = GameManager.instance.experience.ToString() + " kopejais";
            xpBar.localScale = Vector3.one;
        }
        else
        {
            int previousLevelXp = GameManager.instance.GetXpToLevel(currentLevel - 1);
            int currentLevelXp = GameManager.instance.GetXpToLevel(currentLevel);

            int different = currentLevelXp - previousLevelXp;
            int currentXpIntoLevel = GameManager.instance.experience - previousLevelXp;

            float Ratio = (float)currentXpIntoLevel / (float)different;
            xpBar.localScale = new Vector3(Ratio, 1, 1);
            xpText.text = currentXpIntoLevel.ToString() + " / " + different;
        }
    }
}